#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-3100 (cups).

The Common UNIX Printing System provides a portable printing layer for
UNIX® operating systems. It has been developed by Easy Software Products
to promote a standard printing solution for all UNIX vendors and users.
CUPS provides the System V and Berkeley command-line interfaces.

-
Update Information:

This update fixes several PDF handling security issues.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28162);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-0720", "CVE-2007-3387", "CVE-2007-4045", "CVE-2007-4351", "CVE-2007-4352", "CVE-2007-5392", "CVE-2007-5393");
 
 name["english"] = "Fedora Core 7 2007-3100: cups";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cups package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"cups-1.2.12-7.fc7", prefix:"cups-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"cups-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-0720", value:TRUE);
 set_kb_item(name:"CVE-2007-3387", value:TRUE);
 set_kb_item(name:"CVE-2007-4045", value:TRUE);
 set_kb_item(name:"CVE-2007-4351", value:TRUE);
 set_kb_item(name:"CVE-2007-4352", value:TRUE);
 set_kb_item(name:"CVE-2007-5392", value:TRUE);
 set_kb_item(name:"CVE-2007-5393", value:TRUE);
}
