#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-316 (gnupg).

GnuPG (GNU Privacy Guard) is a GNU utility for encrypting data and
creating digital signatures. GnuPG has advanced key management
capabilities and is compliant with the proposed OpenPGP Internet
standard described in RFC2440. Since GnuPG doesn't use any patented
algorithm, it is not compatible with any version of PGP2 (PGP2.x uses
only IDEA for symmetric-key encryption, which is patented worldwide).

Update Information:

This updates GnuPG to version 1.4.7, changing the default
behavior so that gnupg now flags message streams which
contain multiple plaintexts as an error.  This prevents
errors which would occur when applications which called
gnupg assumed that this was already the default behavior.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24822);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-3082", "CVE-2006-3746", "CVE-2006-6169", "CVE-2006-6235");
 
 name["english"] = "Fedora Core 5 2007-316: gnupg";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gnupg package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"gnupg-1.4.7-1", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"gnupg-", release:"FC5") )
{
 set_kb_item(name:"CVE-2006-3082", value:TRUE);
 set_kb_item(name:"CVE-2006-3746", value:TRUE);
 set_kb_item(name:"CVE-2006-6169", value:TRUE);
 set_kb_item(name:"CVE-2006-6235", value:TRUE);
}
