#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-3666 (phpMyAdmin).

phpMyAdmin is a tool written in PHP intended to handle the administration of
MySQL over the Web. Currently it can create and drop databases,
create/drop/alter tables, delete/edit/add fields, execute any SQL statement,
manage keys on fields, manage privileges,export data into various formats and
is available in 50 languages

-
Update Information:

The login page (auth_type cookie) was vulnerable to XSS via the convcharset par
ameter (PMASA-2007-8).


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28311);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5386", "CVE-2007-5976", "CVE-2007-5977");
 
 name["english"] = "Fedora Core 7 2007-3666: phpMyAdmin";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the phpMyAdmin package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"phpMyAdmin-2.11.2.2-1.fc7", prefix:"phpMyAdmin-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"phpMyAdmin-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-5386", value:TRUE);
 set_kb_item(name:"CVE-2007-5976", value:TRUE);
 set_kb_item(name:"CVE-2007-5977", value:TRUE);
}
