#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-3962 (liferea).

Liferea (Linux Feed Reader) is an RSS/RDF feed reader.
It's intended to be a clone of the Windows-only FeedReader.
It can be used to maintain a list of subscribed feeds,
browse through their items, and show their contents.

-
Update Information:

Updated firefox packages that fix several security issues are now available for
Fedora 8.

This update has been rated as having critical security impact by the Fedora Sec
urity Response Team.

Mozilla Firefox is an open source Web browser.

A cross-site scripting flaw was found in the way Firefox handled the jar: URI s
cheme. It was possible for a malicious website to leverage this flaw and conduc
t a cross-site scripting attack against a user running Firefox. (CVE-2007-5947)

Several flaws were found in the way Firefox processed certain malformed web con
tent. A webpage containing malicious content could cause Firefox to crash, or p
otentially execute arbitrary code as the user running Firefox. (CVE-2007-5959)

A race condition existed when Firefox set the 'window.location' property for a
webpage. This flaw could allow a webpage to set an arbitrary Referer header, wh
ich may lead to a Cross-site Request Forgery (CSRF) attack against websites tha
t rely only on the Referer header for protection. (CVE-2007-5960)

Users of Firefox are advised to upgrade to these updated packages, which contai
n backported patches to resolve these issues.



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28347);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5947", "CVE-2007-5959", "CVE-2007-5960");
 
 name["english"] = "Fedora Core 8 2007-3962: liferea";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the liferea package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"liferea-1.4.8-2.fc8", prefix:"liferea-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"liferea-", release:"FC8") )
{
 set_kb_item(name:"CVE-2007-5947", value:TRUE);
 set_kb_item(name:"CVE-2007-5959", value:TRUE);
 set_kb_item(name:"CVE-2007-5960", value:TRUE);
}
