#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-4031 (poppler).

Poppler, a PDF rendering library, it's a fork of the xpdf PDF
viewer developed by Derek Noonburg of Glyph and Cog, LLC.

-
Update Information:

This package contains the latest stable upstream release of poppler.

New upstream version incorporate fixes for following security issues affecting
xpdf code included in poppler: CVE-2007-4352, CVE-2007-5392, CVE-2007-5393

It also includes more headers in the -devel subpackage and fixes a problem in t
he -qt3 subpackage.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29265);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5393");
 
 name["english"] = "Fedora Core 8 2007-4031: poppler";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the poppler package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"poppler-0.6.2-1.fc8", prefix:"poppler-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"poppler-", release:"FC8") )
{
 set_kb_item(name:"CVE-2007-5393", value:TRUE);
}
