#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-4229 (ruby-gnome2).

This is a set of bindings for the GNOME-2.x libraries for use from Ruby.

-
Update Information:

Fix CVE-2007-6183, format string vulnerability


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29277);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-6183");
 
 name["english"] = "Fedora Core 7 2007-4229: ruby-gnome2";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ruby-gnome2 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"ruby-gnome2-0.16.0-18.fc7", prefix:"ruby-gnome2-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"ruby-gnome2-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-6183", value:TRUE);
}
