#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-4354 (qt4).

Qt is a software toolkit for developing applications.

This package contains base tools, like string, xml, and network
handling.

-
Update Information:

An update to the latest upstream release.
Includes fix for security issue CVE-2007-5965 (rhbz#411751).


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29842);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5965");
 
 name["english"] = "Fedora Core 7 2007-4354: qt4";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the qt4 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"qt4-4.3.3-1.fc7", prefix:"qt4-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"qt4-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-5965", value:TRUE);
}
