#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-4447 (e2fsprogs).

The e2fsprogs package contains a number of utilities for creating,
checking, modifying, and correcting any inconsistencies in second
and third extended (ext2/ext3) filesystems. E2fsprogs contains
e2fsck (used to repair filesystem inconsistencies after an unclean
shutdown), mke2fs (used to initialize a partition to contain an
empty ext2 filesystem), debugfs (used to examine the internal
structure of a filesystem, to manually repair a corrupted
filesystem, or to create test cases for e2fsck), tune2fs (used to
modify filesystem parameters), and most of the other core ext2fs
filesystem utilities.

You should install the e2fsprogs package if you need to manage the
performance of an ext2 and/or ext3 filesystem.

-
Update Information:

CVE-2007-5497


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(30025);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5497");
 
 name["english"] = "Fedora Core 8 2007-4447: e2fsprogs";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the e2fsprogs package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"e2fsprogs-1.40.2-12.fc8", prefix:"e2fsprogs-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"e2fsprogs-", release:"FC8") )
{
 set_kb_item(name:"CVE-2007-5497", value:TRUE);
}
