#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-485 (evolution-data-server).

The evolution-data-server package provides a unified backend for programs that
work with contacts, tasks, and calendar information.

It was originally developed for Evolution (hence the name), but is now used by
other packages.

Update Information:

This update fixes a security vulnerability in APOP
authentication. This only affects POP mail accounts.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25179);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "Fedora Core 5 2007-485: evolution-data-server";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the evolution-data-server package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"evolution-data-server-1.6.3-4.fc5", prefix:"evolution-data-server-", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
