#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-540 (mutt).

Mutt is a text-mode mail user agent. Mutt supports color, threading,
arbitrary key remapping, and a lot of customization.

You should install mutt if you have used it in the past and you prefer
it, or if you are new to mail programs and have not decided which one
you are going to use.

Update Information:

This update fixes two security issues:

The APOP protocol allows remote attackers to guess the first
3 characters of a password via man-in-the-middle (MITM)
attacks that use crafted message IDs and MD5 collisions.
(CVE-2007-1558)

Buffer overflow in Mutt 1.4.2 might allow local users to
execute arbitrary code via '&' characters in the GECOS
field, which triggers the overflow during alias expansion.
(CVE-2007-2683)




Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25358);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-3242", "CVE-2006-5297", "CVE-2007-1558", "CVE-2007-2683");
 
 name["english"] = "Fedora Core 5 2007-540: mutt";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mutt package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"mutt-1.4.2.1-8.fc5", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"mutt-", release:"FC5") )
{
 set_kb_item(name:"CVE-2006-3242", value:TRUE);
 set_kb_item(name:"CVE-2006-5297", value:TRUE);
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
 set_kb_item(name:"CVE-2007-2683", value:TRUE);
}
