#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-548 (libexif).

Most digital cameras produce EXIF files, which are JPEG files with
extra tags that contain information about the image. The EXIF library
allows you to parse an EXIF file and read the data from those tags.

Update Information:

This update to the latest upstream release fixes a number of
bugs, among them a possible integer overflow in the
exif_data_load_data_entry function (CVE-2007-2645), which
allows user-assisted remote attackers to cause a denial of
service (crash) or possibly execute arbitrary code via
crafted EXIF data.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25469);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-2645");
 
 name["english"] = "Fedora Core 6 2007-548: libexif";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libexif package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"libexif-0.6.15-1.fc6", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"libexif-", release:"FC6") )
{
 set_kb_item(name:"CVE-2007-2645", value:TRUE);
}
