#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-590 (iscsi-initiator-utils).

The iscsi package provides the server daemon for the iSCSI protocol,
as well as the utility programs used to manage it. iSCSI is a protocol
for distributed disk access using SCSI commands sent over Internet
Protocol networks.

Update Information:

This update to iscsi-initiator-utils is a rebase to the
upstream open-iscsi-2.0-865 release. This release includes
two security fixes, which are described here,
[8]https://bugzilla.redhat.com/bugzilla/show_bug.cgi?id=243719
bug fixes and new features.

The tools in this release use a different db format, but the
tools are able to read old and new formats. If you want to
use the new features you must update the db, by
rediscovering your targets and reconfiguring them. Once the
db has been updated you cannot use older tools on it.

See the README and man pages for information on the new
features.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25511);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "Fedora Core 6 2007-590: iscsi-initiator-utils";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the iscsi-initiator-utils package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"iscsi-initiator-utils-6.2.0.865-0.0.fc6", prefix:"iscsi-initiator-utils-", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
