#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-659 (xorg-x11-xinit).

X.Org X11 X Window System xinit startup scripts



Update information :

* Thu Aug  2 2007 Soren Sandmann <sandmann redhat com> - 1.0.2-16
- Fix bug 212167; CVE-2006-5214.



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25864);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5214");
 
 name["english"] = "Fedora Core 6 2007-659: xorg-x11-xinit";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xorg-x11-xinit package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"xorg-x11-xinit-1.0.2-16.fc6", prefix:"xorg-x11-xinit-", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"xorg-x11-xinit-", release:"FC6") )
{
 set_kb_item(name:"CVE-2006-5214", value:TRUE);
}
