#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-714 (kernel).

The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system:  memory allocation, process allocation, device
input and output, etc.

Update Information:

Update to Linux 2.6.22.8 and 2.6.22.9:
[8]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.22.8
[9]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.22.9

CVE-2007-4571
The snd_mem_proc_read function in sound/core/memalloc.c in
the Advanced Linux Sound Architecture (ALSA) in the Linux
kernel before 2.6.22.8 does not return the correct write
size, which allows local users to obtain sensitive
information (kernel memory contents) via a small count
argument, as demonstrated by multiple reads of
/proc/driver/snd-page-alloc.

Additional fixes:
Revert to the old RTC driver (#265721, #284191)
Disable NCQ for additional SATA drives.
libata pata_sis: DMA fixes (#202291)
libata sata_sil24: IRQ clearing race fixes
net driver r8169: fix hanging (#252955, #292161)
qdisc sfq: fix oops with 2 packet queue (#219895)
ACPI: disable processor C-states suring suspend
ACPI: silence noisy message



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(26934);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-4571");
 
 name["english"] = "Fedora Core 6 2007-714: kernel";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"kernel-2.6.22.9-61.fc6", prefix:"kernel-", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"kernel-", release:"FC6") )
{
 set_kb_item(name:"CVE-2007-4571", value:TRUE);
}
