#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-0136 (libcdio).

This library provides an interface for CD-ROM access. It can be used
by applications that need OS- and device-independent access to CD-ROM
devices.

-
ChangeLog:


Update information :

* Wed Jan  2 2008 Adrian Reber <adrian lisas de> - 0.78.2-4
- fixes #427197 (Long Joliet file name overflows cdio's buffer)


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29846);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 8 2008-0136: libcdio";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libcdio package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"libcdio-0.78.2-4.fc8", prefix:"libcdio-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
