#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-0463 (qimageblitz).

Blitz is an interim image effect library that people can use until KDE 4.1 is
released. KImageEffect, the old image effect class is being dropped for KDE 4.0
and the replacement, Quasar, won't be ready until KDE 4.1. Blitz gives people
something to use in the meantime.

-
Update Information:

This update fixes qimageblitz not to (needlessly) require an executable stack.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29941);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 7 2008-0463: qimageblitz";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the qimageblitz package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"qimageblitz-0.0.4-0.3.svn706674.fc7", prefix:"qimageblitz-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
