#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-0506 (tog-pegasus).

OpenPegasus WBEM Services for Linux enables management solutions that deliver
increased control of enterprise resources. WBEM is a platform and resource
independent DMTF standard that defines a common information model and
communication protocol for monitoring and controlling resources from diverse
sources.

-
ChangeLog:


Update information :

* Thu Jan 10 2008 Vitezslav Crhonek <vcrhonek redhat com> - 2.6.0-3
- Fix PAM authentication buffer overflow (CVE-2008-0003)
Resolves: #427828


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29946);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2008-0003");
 
 name["english"] = "Fedora Core 7 2008-0506: tog-pegasus";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tog-pegasus package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"tog-pegasus-2.6.0-3.fc7", prefix:"tog-pegasus-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"tog-pegasus-", release:"FC7") )
{
 set_kb_item(name:"CVE-2008-0003", value:TRUE);
}
