#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-0831 (xorg-x11-server).

X.Org X11 X server

-
Update Information:

CVE-2007-5760: XFree86-Misc Extension Invalid Array Index Vulnerability
CVE-2007-5958: Xorg / XFree86 file existence disclosure vulnerability
CVE-2007-6427: XInput Extension Memory Corruption Vulnerability
CVE-2007-6428: TOG-CUP Extension Memory Corruption Vulnerability
CVE-2007-6429: EVI and MIT-SHM Extension Integer Overflow Vulnerability
CVE-2008-0006: PCF Font Vulnerability - this patch isn't strictly required with
new version of libXfont.

This contains ajax's fixes for the MITSHM patch.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(30076);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5760", "CVE-2007-5958", "CVE-2007-6427", "CVE-2007-6428", "CVE-2007-6429", "CVE-2008-0006");
 
 name["english"] = "Fedora Core 7 2008-0831: xorg-x11-server";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xorg-x11-server package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"xorg-x11-server-1.3.0.0-15.fc7", prefix:"xorg-x11-server-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"xorg-x11-server-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-5760", value:TRUE);
 set_kb_item(name:"CVE-2007-5958", value:TRUE);
 set_kb_item(name:"CVE-2007-6427", value:TRUE);
 set_kb_item(name:"CVE-2007-6428", value:TRUE);
 set_kb_item(name:"CVE-2007-6429", value:TRUE);
 set_kb_item(name:"CVE-2008-0006", value:TRUE);
}
