#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1198 (rb_libtorrent).

rb_libtorrent is a C++ library that aims to be a good alternative to all
the other BitTorrent implementations around. It is a library and not a full
featured client, although it comes with a few working example clients.

Its main goals are to be very efficient (in terms of CPU and memory usage) as
well as being very easy to use both as a user and developer.

-
Update Information:

A potential remote exploit was found in the  bdecode_recursive routine that
could trigger a stack  overflow when passed malformed message data.     This
release adds a fix for this issue from the upstream  subversion repository that
limits the maximum recursive  depth of this function.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(30157);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 8 2008-1198: rb_libtorrent";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the rb_libtorrent package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"rb_libtorrent-0.12-3.fc8", prefix:"rb_libtorrent-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
