#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1287 (deluge).

Deluge is a new BitTorrent client, created using Python and GTK+. It is
intended to bring a native, full-featured client to Linux GTK+ desktop
environments such as GNOME and XFCE. It supports features such as DHT
(Distributed Hash Tables), PEX (µTorrent-compatible Peer Exchange), and UPnP
(Universal Plug-n-Play) that allow one to more easily share BitTorrent data
even from behind a router with virtually zero configuration of port-forwarding.

-
Update Information:

Version 0.5.8.3 of the Deluge BitTorrent client contains a  security fix for a
remote exploit which could cause Deluge to  crash.    It also fixes some high
CPU usage spikes, loading issues with  the BlocklistImport plugin, and lock-ups
when the tracker  returns data that is not properly UTF8-encoded.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(30162);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 8 2008-1287: deluge";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the deluge package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"deluge-0.5.8.3-1.fc8", prefix:"deluge-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
