#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1512 (wordpress).

Wordpress is an online publishing / weblog package that makes it very easy,
almost trivial, to get information out to people on the web.

-
ChangeLog:


Update information :

* Fri Feb  8 2008 John Berninger <john at ncphotography dot com> - 2.3.3-0
- update to 2.3.3 for security fixes - BZ 431547


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31064);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2008-0664");
 
 name["english"] = "Fedora Core 7 2008-1512: wordpress";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wordpress package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"wordpress-2.3.3-0.fc7", prefix:"wordpress-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"wordpress-", release:"FC7") )
{
 set_kb_item(name:"CVE-2008-0664", value:TRUE);
}
