#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1643 (graphviz).

A collection of tools for the manipulation and layout
of graphs (as in nodes and edges, not as in barcharts).

-
Update Information:

Rebuilt to utilize system gd instead of internal copy.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31079);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2006-4484");
 
 name["english"] = "Fedora Core 7 2008-1643: graphviz";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the graphviz package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"graphviz-2.12-10.fc7", prefix:"graphviz-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"graphviz-", release:"FC7") )
{
 set_kb_item(name:"CVE-2006-4484", value:TRUE);
}
