#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1743 (scponly).

scponly is an alternative 'shell' for system administrators
who would like to provide access to remote users to both
read and write local files without providing any remote
execution priviledges. Functionally, it is best described
as a wrapper to the 'tried and true' ssh suite of applications.

-
ChangeLog:


Update information :

* Wed Feb 13 2008 Tomas Hoger <thoger redhat com> - 4.6-10
- Add patch to prevent restriction bypass using OpenSSH's scp options -F
and -o (CVE-2007-6415, #426072)


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31108);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-6350", "CVE-2007-6415");
 
 name["english"] = "Fedora Core 8 2008-1743: scponly";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the scponly package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"scponly-4.6-10.fc8", prefix:"scponly-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"scponly-", release:"FC8") )
{
 set_kb_item(name:"CVE-2007-6350", value:TRUE);
 set_kb_item(name:"CVE-2007-6415", value:TRUE);
}
