#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1842 (pcre).

Perl-compatible regular expression library.
PCRE has its own native API, but a set of 'wrapper' functions that are based on
the POSIX API are also supplied in the library libpcreposix. Note that this
just provides a POSIX calling interface to PCRE: the regular expressions
themselves still follow Perl syntax and semantics. The header file
for the POSIX-style functions is called pcreposix.h.

-
Update Information:

This update re-based pcre to version 7.3 as used in Fedora 8 to address multipl
e
security issues that cause memory corruption, leading to application crash or
possible execution of arbitrary code.    CVE-2007-1659 (#315871), CVE-2007-1661
(#392931), CVE-2007-1662 (#392921), CVE-2007-4766 (#392891), CVE-2007-4767
(#392901), CVE-2007-4768 (#392911), CVE-2008-0674 (#431660)    This issue may
affect usages of pcre, where regular expressions from untrusted sources are
compiled.  Handling of untrusted data using trusted regular expressions is not
affected by these problems.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31363);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-1659", "CVE-2007-1661", "CVE-2007-1662", "CVE-2007-4766", "CVE-2007-4767", "CVE-2007-4768", "CVE-2008-0674");
 
 name["english"] = "Fedora Core 7 2008-1842: pcre";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pcre package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"pcre-7.3-3.fc7", prefix:"pcre-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"pcre-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-1659", value:TRUE);
 set_kb_item(name:"CVE-2007-1661", value:TRUE);
 set_kb_item(name:"CVE-2007-1662", value:TRUE);
 set_kb_item(name:"CVE-2007-4766", value:TRUE);
 set_kb_item(name:"CVE-2007-4767", value:TRUE);
 set_kb_item(name:"CVE-2007-4768", value:TRUE);
 set_kb_item(name:"CVE-2008-0674", value:TRUE);
}
