#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-2040 (imp).

IMP is the Internet Messaging Program, one of the Horde applications.
It provides webmail access to IMAP and POP3 accounts.

The Horde Project writes web applications in PHP and releases them under
Open Source licenses.  For more information (including help with IMP)
please visit [9]http://www.horde.org/.

-
ChangeLog:


Update information :

* Mon Jan 14 2008 Brandon Holbrook <fedora at theholbrooks.org> 4.1.6-1
- Upgraded to 4.1.6


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31311);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-6018", "CVE-2008-0807");
 
 name["english"] = "Fedora Core 7 2008-2040: imp";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the imp package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"imp-4.1.6-1.fc7", prefix:"imp-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"imp-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-6018", value:TRUE);
 set_kb_item(name:"CVE-2008-0807", value:TRUE);
}
