#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-2070 (dbus).


D-BUS is a system for sending messages between applications. It is
used both for the systemwide message bus service, and as a
per-user-login-session messaging facility.

-
ChangeLog:


Update information :

* Wed Feb 27 2008 David Zeuthen <davidz redhat com> - 1.1.2-9.fc8
- CVE-2008-0595


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31315);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2008-0595");
 
 name["english"] = "Fedora Core 8 2008-2070: dbus";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the dbus package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"dbus-1.1.2-9.fc8", prefix:"dbus-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"dbus-", release:"FC8") )
{
 set_kb_item(name:"CVE-2008-0595", value:TRUE);
}
