#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-2143 (viewvc).

ViewVC is a browser interface for CVS and Subversion version control
repositories. It generates templatized HTML to present navigable directory,
revision, and change log listings. It can display specific versions of files
as well as diffs between those versions. Basically, ViewVC provides the bulk
of the report-like functionality you expect out of your version control tool,
but much more prettily than the average textual command-line program output.

-
Update Information:

These security issues have been fixed:    - omit commits of all-forbidden files
from query results  - disallow direct URL navigation to hidden CVSROOT folder
-
strip forbidden paths from revision view  - don't traverse log history thru
forbidden locations  - honor forbiddenness via diff view path parameters


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31325);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 7 2008-2143: viewvc";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the viewvc package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"viewvc-1.0.5-1.fc7", prefix:"viewvc-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
