#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-2212 (kronolith).

Kronolith is the Horde calendar application.  It provides repeating
events, all-day events, custom fields, keywords, and managing multiple
users through Horde Authentication.  The calendar API that Kronolith
uses is abstracted; MCAL and SQL drivers are currently provided.

The Horde Project writes web applications in PHP and releases them under
Open Source licenses.  For more information (including help with Kronolith)
please visit [9]http://www.horde.org/.

READ /usr/share/doc/kronolith-2.1.7/README.Fedora AFTER INSTALLING FOR
MORE INSTRUCTIONS!

-
Update Information:

Fix privilege escalation in Horde API.                            Fix missing
ownership validation on share changes.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31367);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 7 2008-2212: kronolith";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kronolith package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"kronolith-2.1.7-1.fc7", prefix:"kronolith-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
