#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-2258 (nx).

NX provides a proxy system for the X Window System.

-
ChangeLog:


Update information :

* Wed Jan  2 2008 Axel Thimm <Axel Thimm ATrpms net> - 3.1.0-25
- Update to 3.1.0.
- add nxcompshad, nxauth; remove nxviewer, nxdesktop.
- add -fPIC for ppc64.
- Propagate %{optflags} for x86_64, too.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31370);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 8 2008-2258: nx";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the nx package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"nx-3.1.0-25.1.fc8", prefix:"nx-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
