#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote Windows host contains a browser plugin that is affected by
multiple issues. 

Description :

According to its version number, the instance of Flash Player on the
remote Windows host is affected by multiple issues, including several
which could allow for arbitrary code execution by means of a malicious
SWF file. 

See also :

http://www.adobe.com/support/security/bulletins/apsb07-20.html

Solution :

Upgrade to Flash Player version 9.0.115.0 / 7.0.73.0 or later. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(29741);
  script_version("$Revision: 1.6 $");
  script_cve_id(
    "CVE-2007-4324",
    "CVE-2007-4768",
    "CVE-2007-5275",
    "CVE-2007-6242",
    "CVE-2007-6243",
    "CVE-2007-6244",
    "CVE-2007-6245",
    "CVE-2007-6246"
  );
  script_bugtraq_id(
    25260,
    26346,
    26930,
    26949,
    26951,
    26960,
    26965,
    26966,
    26969
  );
  script_xref(name:"OSVDB", value:"40759");
  script_xref(name:"OSVDB", value:"40760");
  script_xref(name:"OSVDB", value:"40766");

  script_name(english:"Flash Player APSB07-20");
  script_summary(english:"Checks version of Flash Player");
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("flash_player_installed.nasl");
  script_require_keys("SMB/Flash_Player/installed");

  exit(0);
}


if (!get_kb_item("SMB/Flash_Player/installed")) exit(0);


# Identify vulnerable versions.
info = "";

foreach variant (make_list("Plugin", "ActiveX"))
{
  vers = get_kb_list("SMB/Flash_Player/"+variant+"/Version/*");
  files = get_kb_list("SMB/Flash_Player/"+variant+"/File/*");
  if (!isnull(vers) && !isnull(files))
  {
    foreach key (keys(vers))
    {
      num = key - ("SMB/Flash_Player/"+variant+"/Version/");

      ver = vers[key];
      if (ver)
      {
        iver = split(ver, sep:'.', keep:FALSE);
        for (i=0; i<max_index(iver); i++)
          iver[i] = int(iver[i]);

        if (
          (iver[0] == 7 && iver[1] == 0 && iver[2] < 73) ||
          (iver[0] == 8 && iver[1] == 0 && iver[2] <= 35) ||
          (iver[0] == 9 && iver[1] == 0 && iver[2] < 115)
        )
        {
          file = files["SMB/Flash_Player/"+variant+"/File/"+num];
          if (variant == "Plugin")
          {
            info += '  - Browser Plugin (for Firefox / Netscape / Opera) :\n';
          }
          else if (variant == "ActiveX")
          {
            info += '  - ActiveX control (for Internet Explorer) :\n';
          }
          info += '    ' + file + ', ' + ver + '\n';
        }
      }
    }
  }
}


if (info)
{
  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "Nessus has identified the following vulnerable instance(s) of Flash\n",
    "Player installed on the remote host :\n",
    "\n",
    info
  );
  security_hole(port:get_kb_item("SMB/transport"), data:report);
}
