#
#
# (C) Tenable Network Security
#


 desc = "
Synopsis :

The remote Windows host has a browser plugin that is prone to buffer
overflow attacks. 

Description :

The remote host has an old version of the Flash Player plugin
installed. 

An attacker may use this flaw to construct a malicious web site with a
badly-formed Flash animation which, when viewed using a vulnerable
version of the software, will cause a buffer overflow and allow for
arbitrary code execution subject to the plugin user's privileges. 

See also : 

http://www.adobe.com/devnet/security/security_zone/mpsb03-03.html

Solution :

Upgrade to version 6.0.79.0 or later. 

Risk factor : 

Medium / CVSS Base Score : 6 
(AV:R/AC:H/Au:NR/C:P/A:P/I:P/B:N)";



if(description)
{
  script_id(11323);
  script_version("$Revision: 1.21 $");

  script_bugtraq_id(7005);

  script_name(english:"Security issues in the remote version of FlashPlayer");
  script_summary(english:"Checks version of Flash Player");

  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2003-2007 Tenable Network Security");
 
  script_dependencies("flash_player_installed.nasl");
  script_require_keys("SMB/Flash_Player/installed");

  exit(0);
}


if (!get_kb_item("SMB/Flash_Player/installed")) exit(0);


# Identify vulnerable versions.
info = "";

foreach variant (make_list("Plugin", "ActiveX"))
{
  vers = get_kb_list("SMB/Flash_Player/"+variant+"/Version/*");
  files = get_kb_list("SMB/Flash_Player/"+variant+"/File/*");
  if (!isnull(vers) && !isnull(files))
  {
    foreach key (keys(vers))
    {
      num = key - ("SMB/Flash_Player/"+variant+"/Version/");

      ver = vers[key];
      if (ver)
      {
        iver = split(ver, sep:'.', keep:FALSE);
        for (i=0; i<max_index(iver); i++)
          iver[i] = int(iver[i]);

        if (
          iver[0] < 6 ||
          (iver[0] == 6 && iver[1] == 0 && iver[2] < 79)
        )
        {
          file = files["SMB/Flash_Player/"+variant+"/File/"+num];
          if (variant == "Plugin")
          {
            info += '  - Browser Plugin (for Firefox / Netscape / Opera) :\n';
          }
          else if (variant == "ActiveX")
          {
            info += '  - ActiveX control (for Internet Explorer) :\n';
          }
          info += '    ' + file + ', ' + ver + '\n';
        }
      }
    }
  }
}


if (info)
{
  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "Nessus has identified the following vulnerable instance(s) of Flash\n",
    "Player installed on the remote host :\n",
    "\n",
    info
  );
  security_warning(port:get_kb_item("SMB/transport"), data:report);
}
