#
# (C) Tenable Network Security
#
# This script contains information extracted from VuXML :
#
# Copyright 2003-2006 Jacques Vidrine and contributors
#
# Redistribution and use in source (VuXML) and 'compiled' forms (SGML,
# HTML, PDF, PostScript, RTF and so forth) with or without modification,
# are permitted provided that the following conditions are met:
# 1. Redistributions of source code (VuXML) must retain the above
#   copyright notice, this list of conditions and the following
#   disclaimer as the first lines of this file unmodified.
# 2. Redistributions in compiled form (transformed to other DTDs,
#   published online in any format, converted to PDF, PostScript,
#   RTF and other formats) must reproduce the above copyright
#   notice, this list of conditions and the following disclaimer
#   in the documentation and/or other materials provided with the
#   distribution.
#
# THIS DOCUMENTATION IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
# OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
# OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS DOCUMENTATION,
# EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#
#
 seealso  = '\n';

if ( description )
{
 script_id(29849);
 script_version("$Revision: 1.2 $");
 script_cve_id("CVE-2007-5476");
 script_cve_id("CVE-2007-6246");
 script_cve_id("CVE-2007-4324");
 script_cve_id("CVE-2007-6245");
 script_cve_id("CVE-2007-6244");
 script_cve_id("CVE-2007-6243");
 script_cve_id("CVE-2007-5275");
 script_cve_id("CVE-2007-4768");
 script_cve_id("CVE-2007-6242");

 script_name(english:"FreeBSD : linux-flashplugin -- multiple vulnerabilities (1063)");


desc["english"] = "
The remote host is missing an update to the system

The following package is affected: linux-flashplugin

Solution : Update the package on the remote host
See also : " + seealso; 
 script_description(english:desc["english"]);
 script_summary(english:"Check for linux-flashplugin");
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}

include('freebsd_package.inc');


pkg_test(pkg:"linux-flashplugin>=9.0<9.0r115",
     url:"http://www.FreeBSD.org/ports/portaudit/562cf6c4-b9f1-11dc-a302-000102cc8983.html",
     problem:'linux-flashplugin -- multiple vulnerabilities',
     seealso:seealso);

pkg_test(pkg:"linux-flashplugin>=7.0<7.0r73",
     url:"http://www.FreeBSD.org/ports/portaudit/562cf6c4-b9f1-11dc-a302-000102cc8983.html",
     problem:'linux-flashplugin -- multiple vulnerabilities',
     seealso:seealso);
