#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25548);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-3273");
  script_bugtraq_id(24498);
  script_xref(name:"OSVDB", value:"38470");

  script_name(english:"FuseTalk txForumID Parameter SQL Injection Vulnerability");
  script_summary(english:"Tries to generate a SQL error");

  desc = "
Synopsis :

The remote web server contains a ColdFusion script that is prone to a
SQL injection attack. 

Description :

The remote host is running FuseTalk, a discussion forum implemented in
ColdFusion. 

The version of FuseTalk installed on the remote host fails to properly
sanitize user-supplied input to the 'txForumID' parameter before using
it in the 'forum/include/error/forumerror.cfm' script in database
queries.  An unauthenticated remote attacker can leverage this issue
to launch SQL injection attacks against the affected application. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2007-06/0227.html

Solution :

Unknown at this time.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


exploit = string("'", SCRIPT_NAME);


# Loop through various directories.
if (thorough_tests) dirs = make_list("/fusetalk/forum", "/forums/forum", "/forum/forum", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Make sure the affected script exists.
  url = string(dir, "/include/error/forumerror.cfm");

  req = http_get(item:string(url, "?errorno=3"), port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
  if (res == NULL) exit(0);

  # If it does...
  if (
    'name="FT_ACTION" ' >< res &&
    res =~ 'NAME="txForumID" '
  )
  {
    postdata = string(
      "txForumID=", urlencode(str:exploit), "&",
      "FT_ACTION=SearchURL"
    );
    req = string(
      "POST ", url, " HTTP/1.1\r\n",
      "Host: ", get_host_name(), "\r\n",
      "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
      "Content-Type: application/x-www-form-urlencoded\r\n",
      "Content-Length: ", strlen(postdata), "\r\n",
      "\r\n",
      postdata
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
    if (res == NULL) exit(0);

    # There's a problem if we see a SQL error.
    if (
      "<title>Error Occurred While Processing Request" >< res &&
      (
        string("near ", exploit, " and vchsettingname =") >< res ||
        string("where iforumid = ", exploit, " and vchsettingname =") >< res
      )
    )
    {
      security_hole(port);
      exit(0);
    }
  }
}
