# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200611-05.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(23670);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200611-05");
 script_cve_id("CVE-2006-5778");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200611-05
(Netkit FTP Server: Privilege escalation)


    Paul Szabo reported that an incorrect seteuid() call after the chdir()
    function can allow an attacker to access a normally forbidden
    directory, in some very particular circumstances, for example when the
    NFS-hosted targetted directory is not reachable by the client-side root
    user. Additionally, some potentially exploitable unchecked setuid()
    calls were also fixed.
  
Impact

    A local attacker might craft his home directory to gain access through
    ftpd to normally forbidden directories like /root, possibly with
    writing permissions if seteuid() fails and if the ftpd configuration
    allows that. The unchecked setuid() calls could also lead to a root FTP
    login, depending on the FTP server configuration.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-5778


Solution: 
    All Netkit FTP Server users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-ftp/ftpd-0.17-r4"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200611-05] Netkit FTP Server: Privilege escalation");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Netkit FTP Server: Privilege escalation');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-ftp/ftpd", unaffected: make_list("ge 0.17-r4"), vulnerable: make_list("lt 0.17-r4")
)) { security_hole(0); exit(0); }
