# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200611-06.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(23671);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200611-06");
 script_cve_id("CVE-2006-5051", "CVE-2006-5052");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200611-06
(OpenSSH: Multiple Denial of Service vulnerabilities)


    Tavis Ormandy of the Google Security Team has discovered a
    pre-authentication vulnerability, causing sshd to spin until the login
    grace time has been expired. Mark Dowd found an unsafe signal handler
    that was vulnerable to a race condition. It has also been discovered
    that when GSSAPI authentication is enabled, GSSAPI will in certain
    cases incorrectly abort.
  
Impact

    The pre-authentication and signal handler vulnerabilities can cause a
    Denial of Service in OpenSSH. The vulnerability in the GSSAPI
    authentication abort could be used to determine the validity of
    usernames on some platforms.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-5051
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-5052
    http://www.openssh.com/txt/release-4.4


Solution: 
    All OpenSSH users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-misc/openssh-4.4_p1-r5"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200611-06] OpenSSH: Multiple Denial of Service vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'OpenSSH: Multiple Denial of Service vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-misc/openssh", unaffected: make_list("ge 4.4_p1-r5"), vulnerable: make_list("lt 4.4_p1-r5")
)) { security_warning(0); exit(0); }
