# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200611-12.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(23706);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200611-12");
 script_cve_id("CVE-2006-5467");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200611-12
(Ruby: Denial of Service vulnerability)


    Zed Shaw, Jeremy Kemper, and Jamis Buck of the Mongrel project reported
    that the CGI library shipped with Ruby is vulnerable to a remote Denial
    of Service by an unauthenticated user.
  
Impact

    The vulnerability can be exploited by sending the cgi.rb library an
    HTTP request with multipart MIME encoding that contains a malformed
    MIME boundary specifier beginning with "-" instead of "--". Successful
    exploitation of the vulnerability causes the library to go into an
    infinite loop waiting for additional non-existent input.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-5467


Solution: 
    All Ruby users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-lang/ruby-1.8.5-r3"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200611-12] Ruby: Denial of Service vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Ruby: Denial of Service vulnerability');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-lang/ruby", unaffected: make_list("ge 1.8.5-r3"), vulnerable: make_list("lt 1.8.5-r3")
)) { security_warning(0); exit(0); }
