# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200611-15.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(23709);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200611-15");
 script_cve_id("CVE-2006-1141");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200611-15
(qmailAdmin: Buffer overflow)


    qmailAdmin fails to properly handle the "PATH_INFO" variable in
    qmailadmin.c. The PATH_INFO is a standard CGI environment variable
    filled with user supplied data.
  
Impact

    A remote attacker could exploit this vulnerability by sending
    qmailAdmin a maliciously crafted URL that could lead to the execution
    of arbitrary code with the permissions of the user running qmailAdmin.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-1141


Solution: 
    All qmailAdmin users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-mail/qmailadmin-1.2.10"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200611-15] qmailAdmin: Buffer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'qmailAdmin: Buffer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-mail/qmailadmin", unaffected: make_list("ge 1.2.10"), vulnerable: make_list("lt 1.2.10")
)) { security_hole(0); exit(0); }
