# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200611-17.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(23725);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200611-17");
 script_cve_id("CVE-2006-5969");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200611-17
(fvwm: fvwm-menu-directory fvwm command injection)


    Tavis Ormandy of the Gentoo Linux Security Audit Team discovered that
    fvwm-menu-directory does not sufficiently sanitise directory names
    prior to generating menus.
  
Impact

    A local attacker who can convince an fvwm-menu-directory user to browse
    a directory they control could cause fvwm commands to be executed with
    the privileges of the fvwm user. Fvwm commands can be used to execute
    arbitrary shell commands.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-5969


Solution: 
    All fvwm users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=x11-wm/fvwm-2.5.18-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200611-17] fvwm: fvwm-menu-directory fvwm command injection");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'fvwm: fvwm-menu-directory fvwm command injection');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "x11-wm/fvwm", unaffected: make_list("ge 2.5.18-r1"), vulnerable: make_list("lt 2.5.18-r1")
)) { security_warning(0); exit(0); }
