# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200611-18.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(23726);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200611-18");
 script_cve_id("CVE-2006-0804");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200611-18
(TIN: Multiple buffer overflows)


    Urs Janssen and Aleksey Salow have reported multiple buffer overflows
    in TIN. Additionally, the OpenPKG project has reported an allocation
    off-by-one flaw which can lead to a buffer overflow.
  
Impact

    An attacker could entice a TIN user to read a specially crafted news
    article, and execute arbitrary code with the rights of the user running
    TIN.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://www.openpkg.org/security/advisories/OpenPKG-SA-2006.005-tin.html
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-0804


Solution: 
    All TIN users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-nntp/tin-1.8.2"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200611-18] TIN: Multiple buffer overflows");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'TIN: Multiple buffer overflows');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-nntp/tin", unaffected: make_list("ge 1.8.2"), vulnerable: make_list("lt 1.8.2")
)) { security_warning(0); exit(0); }
