# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200612-03.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(23855);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200612-03");
 script_cve_id("CVE-2006-6169", "CVE-2006-6235");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200612-03
(GnuPG: Multiple vulnerabilities)


    Hugh Warrington has reported a boundary error in GnuPG, in the
    "ask_outfile_name()" function from openfile.c: the
    make_printable_string() function could return a string longer than
    expected. Additionally, Tavis Ormandy of the Gentoo Security Team
    reported a design error in which a function pointer can be incorrectly
    dereferenced.
  
Impact

    A remote attacker could entice a user to interactively use GnuPG on a
    crafted file and trigger the boundary error, which will result in a
    buffer overflow. They could also entice a user to process a signed or
    encrypted file with gpg or gpgv, possibly called through another
    application like a mail client, to trigger the dereference error. Both
    of these vulnerabilities would result in the execution of arbitrary
    code with the permissions of the user running GnuPG. gpg-agent, gpgsm
    and other tools are not affected.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6169
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6235


Solution: 
    All GnuPG users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose "=app-crypt/gnupg-1.4*"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200612-03] GnuPG: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'GnuPG: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-crypt/gnupg", unaffected: make_list("ge 1.4.6"), vulnerable: make_list("lt 1.4.6")
)) { security_warning(0); exit(0); }
