# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200612-08.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(23860);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200612-08");
 script_cve_id("CVE-2006-5462", "CVE-2006-5463", "CVE-2006-5464", "CVE-2006-5747", "CVE-2006-5748");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200612-08
(SeaMonkey: Multiple vulnerabilities)


    The SeaMonkey project is vulnerable to arbitrary JavaScript bytecode
    execution and arbitrary code execution.
  
Impact

    An attacker could entice a user to load malicious JavaScript or a
    malicious web page with a SeaMonkey application and execute arbitrary
    code with the rights of the user running those products. It is
    important to note that in the SeaMonkey email client, JavaScript is
    disabled by default.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-5462
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-5463
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-5464
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-5747
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-5748


Solution: 
    All SeaMonkey users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-client/seamonkey-1.0.6"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200612-08] SeaMonkey: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'SeaMonkey: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-client/seamonkey", unaffected: make_list("ge 1.0.6"), vulnerable: make_list("lt 1.0.6")
)) { security_hole(0); exit(0); }
