# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200612-18.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(23955);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200612-18");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200612-18
(ClamAV: Denial of Service)


    Hendrik Weimer discovered that ClamAV fails to properly handle deeply
    nested MIME multipart/mixed content.
  
Impact

    By sending a specially crafted email with deeply nested MIME
    multipart/mixed content an attacker could cause ClamAV to crash.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6481


Solution: 
    All ClamAV users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-antivirus/clamav-0.88.7"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200612-18] ClamAV: Denial of Service");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'ClamAV: Denial of Service');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-antivirus/clamav", unaffected: make_list("ge 0.88.7"), vulnerable: make_list("lt 0.88.7")
)) { security_warning(0); exit(0); }
