# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200701-01.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(23990);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200701-01");
 script_cve_id("CVE-2006-6301");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200701-01
(DenyHosts: Denial of Service)


    Tavis Ormandy of the Gentoo Linux Security Audit Team discovered that
    DenyHosts used an incomplete regular expression to parse failed login
    attempts.
  
Impact

    A remote unauthenticated attacker can add arbitrary hosts to the
    blacklist by attempting to login with a specially crafted username. An
    attacker may use this to prevent legitimate users from accessing a host
    remotely.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6301


Solution: 
    All DenyHosts users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-admin/denyhosts-2.6"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200701-01] DenyHosts: Denial of Service");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'DenyHosts: Denial of Service');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-admin/denyhosts", unaffected: make_list("ge 2.6"), vulnerable: make_list("lt 2.6")
)) { security_warning(0); exit(0); }
