# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200701-02.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(23991);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200701-02");
 script_cve_id("CVE-2006-6497", "CVE-2006-6498", "CVE-2006-6499", "CVE-2006-6500", "CVE-2006-6501", "CVE-2006-6502", "CVE-2006-6503", "CVE-2006-6504", "CVE-2006-6506", "CVE-2006-6507");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200701-02
(Mozilla Firefox: Multiple vulnerabilities)


    An anonymous researcher found evidence of memory corruption in the way
    Mozilla Firefox handles certain types of SVG comment DOM nodes.
    Additionally, Frederik Reiss discovered a heap-based buffer overflow in
    the conversion of a CSS cursor. Other issues with memory corruption
    were also fixed. Mozilla Firefox also contains less severe
    vulnerabilities involving JavaScript and Java.
  
Impact

    An attacker could entice a user to view a specially crafted web page
    that will trigger one of the vulnerabilities, possibly leading to the
    execution of arbitrary code. It is also possible for an attacker to
    perform cross-site scripting attacks, leading to the exposure of
    sensitive information, like user credentials.
  
Workaround

    There are no known workarounds for all the issues at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6497
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6498
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6499
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6500
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6501
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6502
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6503
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6504
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6506
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6507


Solution: 
    All Mozilla Firefox users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-client/mozilla-firefox-1.5.0.9"
    All Mozilla Firefox binary release users should upgrade to the latest
    version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-client/mozilla-firefox-bin-1.5.0.9"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200701-02] Mozilla Firefox: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Mozilla Firefox: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-client/mozilla-firefox-bin", unaffected: make_list("ge 1.5.0.9"), vulnerable: make_list("lt 1.5.0.9")
)) { security_warning(0); exit(0); }
if (qpkg_check(package: "www-client/mozilla-firefox", unaffected: make_list("ge 1.5.0.9"), vulnerable: make_list("lt 1.5.0.9")
)) { security_warning(0); exit(0); }
