# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200701-10.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24208);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200701-10");
 script_cve_id("CVE-2006-6808", "CVE-2007-0107", "CVE-2007-0109");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200701-10
(WordPress: Multiple vulnerabilities)


    When decoding trackbacks with alternate character sets, WordPress does
    not correctly sanitize the entries before further modifying a SQL
    query. WordPress also displays different error messages in wp-login.php
    based upon whether or not a user exists. David Kierznowski has
    discovered that WordPress fails to properly sanitize recent file
    information in /wp-admin/templates.php before sending that information
    to a browser.
  
Impact

    An attacker could inject arbitrary SQL into WordPress database queries.
    An attacker could also determine if a WordPress user existed by trying
    to login as that user, better facilitating brute force attacks. Lastly,
    an attacker authenticated to view the administrative section of a
    WordPress instance could try to edit a file with a malicious filename;
    this may cause arbitrary HTML or JavaScript to be executed in users\'
    browsers viewing /wp-admin/templates.php.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6808
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0107
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0109


Solution: 
    All WordPress users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-apps/wordpress-2.0.6"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200701-10] WordPress: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'WordPress: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-apps/wordpress", unaffected: make_list("ge 2.0.6"), vulnerable: make_list("lt 2.0.6")
)) { security_warning(0); exit(0); }
