# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200701-11.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24209);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200701-11");
 script_cve_id("CVE-2006-6175");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200701-11
(Kronolith: Local file inclusion)


    Kronolith contains a mistake in lib/FBView.php where a raw, unfiltered
    string is used instead of a sanitized string to view local files.
  
Impact

    An authenticated attacker could craft an HTTP GET request that uses
    directory traversal techniques to execute any file on the web server as
    PHP code, which could allow information disclosure or arbitrary code
    execution with the rights of the user running the PHP application
    (usually the webserver user).
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6175


Solution: 
    All horde-kronolith users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-apps/horde-kronolith-2.1.4"
  

Risk factor : Low
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200701-11] Kronolith: Local file inclusion");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Kronolith: Local file inclusion');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-apps/horde-kronolith", unaffected: make_list("ge 2.1.4"), vulnerable: make_list("lt 2.1.4")
)) { security_warning(0); exit(0); }
