# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200701-12.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24210);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200701-12");
 script_cve_id("CVE-2006-6104");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200701-12
(Mono: Information disclosure)


    Jos Ramn Palanco has discovered that the System.Web class in the
    XSP for the ASP.NET server 1.1 through 2.0 in Mono does not properly
    validate or sanitize local pathnames which could allow server-side file
    content disclosure.
  
Impact

    An attacker could append a space character to a URI and obtain
    unauthorized access to the source code of server-side files. An
    attacker could also read credentials by requesting Web.Config%20 from a
    Mono server.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6104


Solution: 
    All Mono users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-lang/mono-1.2.2.1"
  

Risk factor : Low
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200701-12] Mono: Information disclosure");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Mono: Information disclosure');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-lang/mono", unaffected: make_list("ge 1.2.2.1"), vulnerable: make_list("lt 1.2.2.1")
)) { security_warning(0); exit(0); }
