# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200701-15.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24251);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200701-15");
 script_cve_id("CVE-2006-6731", "CVE-2006-6736", "CVE-2006-6737", "CVE-2006-6745");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200701-15
(Sun JDK/JRE: Multiple vulnerabilities)


    Chris Evans has discovered multiple buffer overflows in Sun JDK and Sun
    JRE possibly related to various AWT or font layout functions. Tom
    Hawtin has discovered an unspecified vulnerability in Sun JDK and Sun
    JRE relating to unintended applet data access. He has also discovered
    multiple other unspecified vulnerabilities in Sun JDK and Sun JRE
    allowing unintended Java applet or application resource acquisition.
  
Impact

    An attacker could entice a user to run a specially crafted Java applet
    or application that could read, write, or execute local files with the
    privileges of the user running the JVM; access data maintained in other
    Java applets; or escalate the privileges of the currently running Java
    applet or application allowing for unauthorized access to system
    resources.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6731
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6736
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6737
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6745


Solution: 
    All Sun Java Development Kit users should upgrade to the latest
    version:
    # emerge --sync
    # emerge --ask --oneshot --verbose "dev-java/sun-jdk"
    All Sun Java Runtime Environment users should upgrade to the latest
    version:
    # emerge --sync
    # emerge --ask --oneshot --verbose "dev-java/sun-jre-bin"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200701-15] Sun JDK/JRE: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Sun JDK/JRE: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-java/sun-jre-bin", unaffected: make_list("ge 1.4.2.13", "ge 1.5.0.09"), vulnerable: make_list("lt 1.4.2.13", "lt 1.5.0.09")
)) { security_warning(0); exit(0); }
if (qpkg_check(package: "dev-java/sun-jdk", unaffected: make_list("ge 1.4.2.13", "ge 1.5.0.09"), vulnerable: make_list("lt 1.4.2.13", "lt 1.5.0.09")
)) { security_warning(0); exit(0); }
